package org.bloginthecloud.sample;

import java.io.IOException;

import org.jdom.JDOMException;
import org.restlet.Client;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.representation.StringRepresentation;
import org.w3c.dom.DOMException;

public class AzureQueue {

	/**
	 * @param args
	 * @throws IOException
	 * @throws DOMException
	 * @throws JDOMException
	 */

	public static void main(String[] args) throws DOMException, IOException,
			JDOMException {
		Response resp = CreateQueue("toto");
		System.out.println(resp.getStatus());
	}

	public static Response CreateQueue(String queue) {
		String uri = "http://bitc.queue.core.windows.net/" + queue;
		Request request = new Request(Method.PUT, uri);
		return ProcessRequest(request);
	}

	public static QueueMessage Pop(String queue) throws JDOMException,
			IOException {
		Response response = GetMessage("restletqueue");
		QueueMessage msg = new QueueMessage(response);
		DeleteMessage("restletqueue", msg);

		return msg;
	}

	public static Response DeleteQueue(String queue) {
		String uri = "http://bitc.queue.core.windows.net/" + queue;
		Request request = new Request(Method.DELETE, uri);
		return ProcessRequest(request);
	}

	public static Response DeleteMessage(String queue, QueueMessage msg)
			throws IOException, JDOMException {
		String uri = "http://bitc.queue.core.windows.net/" + queue
				+ "/messages/" + msg.id + "?popreceipt=" + msg.popReceipt;
		Request request = new Request(Method.DELETE, uri);
		return ProcessRequest(request);
	}

	public static Response ClearMessages(String queue) {
		String uri = "http://bitc.queue.core.windows.net/" + queue
				+ "/messages";
		Request request = new Request(Method.DELETE, uri);
		return ProcessRequest(request);
	}

	/**
	 * @return
	 */
	public static Response GetMessage(String queue) {
		String uri = "http://bitc.queue.core.windows.net/" + queue
				+ "/messages";
		Request request = new Request(Method.GET, uri);
		return ProcessRequest(request);
	}

	public static Response PutMessage(String queue, String message) {
		String queueMessage = "<QueueMessage><MessageText>" + message
				+ "</MessageText></QueueMessage>";
		StringRepresentation rep = new StringRepresentation(queueMessage);
		String uri = "http://bitc.queue.core.windows.net/" + queue
				+ "/messages";

		Request request = new Request(Method.POST, uri, rep);

		return ProcessRequest(request);
	}

	public static Response ProcessRequest(Request request) {
		ChallengeScheme scheme = ChallengeScheme.HTTP_MS_SHAREDKEY;
		// Identifiant d'acces aux services SDS
		ChallengeResponse authentication = new ChallengeResponse(
				scheme,
				"ACCOUNT NAME",
				"PASSWORD");
		request.setChallengeResponse(authentication);
		// Ask to the HTTP client connector to handle the call
		Client client = new Client(Protocol.HTTP);

		return client.handle(request);
	}
}
